/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	Header File for Workplane Convenience Functions.


#pragma once

HRESULT __declspec(dllexport) ReverseAxes(IDirection **retval1, IDirection **retval2) ;

HRESULT __declspec(dllexport) RotateAxes(double angle, IDirection **retval1, IDirection **retval2) ;

HRESULT __declspec(dllexport) TranslateAxes(double xTranslation, double yTranslation, IVector **retval1) ;

HRESULT __declspec(dllexport) RepositionAxes(double xTranslation, double yTranslation, double angle,
					   IVector **retval1, IDirection **retval2, IDirection **retval3) ;

HRESULT __declspec(dllexport) Orientedplane(ITopology *pEdge,double angle,CString workplaneName,
					  CString sketchName,VARIANT_BOOL bNoSketch,long color,
					  IWorkplane **retDispatch) ;

HRESULT __declspec(dllexport) PlaneThroughObjects(ITopology *pFirstTopology, ITopology *pSecondTopology,
							CString workplaneName,CString sketchName,
							VARIANT_BOOL bNoSketch,long color,IWorkplane **retDispatch) ;

HRESULT __declspec(dllexport) Offsetplane(ITopology *pGeometry, double offsetDistance, CString workplaneName,
					CString sketchName, VARIANT_BOOL bNoSketch, long color,
					IWorkplane **retDispatch) ;

HRESULT __declspec(dllexport) Midplane(ITopology *pFirstGeometry, ITopology *pSecondGeometry,
				 CString workplaneName, CString sketchName, VARIANT_BOOL bNoSketch,
				 long color, IWorkplane **retDispatch) ;

HRESULT __declspec(dllexport) PlaneOfObject(ITopology *pFirstTopology, CString workplaneName,
					  CString sketchName, VARIANT_BOOL bNoSketch, long color,
					  IWorkplane **retDispatch) ;

HRESULT __declspec(dllexport) NewSketch(IWorkplane *pWorkplane, int color, CString sketchName,
				  ISketch **pSketch) ;

HRESULT __declspec(dllexport) HideOtherSketches() ;

